﻿namespace Hims.Api.Hubs
{
    using System;

    /// <summary>
    /// The communication type.
    /// </summary>
    public enum CommunicationType
    {
        /// <summary>
        /// The call.
        /// </summary>
        Call = 1,

        /// <summary>
        /// The notify.
        /// </summary>
        Notify = 2,

        /// <summary>
        /// The reject.
        /// </summary>
        Reject = 3,

        /// <summary>
        /// The intimate alt one.
        /// </summary>
        CloseAll = 4,

        /// <summary>
        /// The intimate alt one.
        /// </summary>
        Join = 5,

        /// <summary>
        /// The intimate alt one.
        /// </summary>
        Close = 6,

        /// <summary>
        /// The appointment refresh.
        /// </summary>
        AppointmentRefresh = 7,

        /// <summary>
        /// The appointment add refresh.
        /// </summary>
        AppointmentAddRefresh = 8,

        /// <summary>
        /// The message refresh.
        /// </summary>
        MessageRefresh = 9,

        /// <summary>
        /// The cancel.
        /// </summary>
        Cancel = 10,

        /// <summary>
        /// The video initiate
        /// </summary>
        Initiate = 11,

        /// <summary>
        /// The external join
        /// </summary>
        ExternalJoin = 12
    }

    /// <summary>
    /// The communication message.
    /// </summary>
    public class CommunicationMessage
    {
        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public CommunicationType Type { get; set; }

        /// <summary>
        /// Gets or sets the unique id.
        /// </summary>
        public string UniqueId { get; set; }

        /// <summary>
        /// Gets or sets the user unique id.
        /// </summary>
        public string UserUniqueId { get; set; }

        /// <summary>
        /// Gets or sets the main eid.
        /// </summary>
        public string MainEid { get; set; }

        /// <summary>
        /// Gets or sets the main id.
        /// </summary>
        public int MainId { get; set; }

        /// <summary>
        /// Gets or sets the main id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the main id.
        /// </summary>
        public int CallerId { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the content.
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTimeOffset? Date { get; set; }

        /// <summary>
        /// Gets or sets the is creating.
        /// </summary>
        public bool? IsCreating { get; set; }

        /// <summary>
        /// Gets or sets the is creating.
        /// </summary>
        public int TelemedicineId { get; set; }
        public bool StartAudioOnly { get; internal set; }
        public int RoleId { get; internal set; }
        public int NotifyToId { get; internal set; }
        public string ClientName { get; internal set; }
    }

    public class CommunicationMessageAlt
    {
        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// Gets or sets the group name.
        /// </summary>
        public string GroupName { get; set; }
        public string? CubicleName { get; set; }
        public string PatientName { get; set; }
        public int TokenNumber { get; set; }
    }
}
